# -*-makefile-*-
#
# Copyright (C) 2006 by Robert Schwebel
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
CROSS_PACKAGES-$(PTXCONF_CROSS_GCC_FIRST) += cross-gcc-first

#
# Paths and names
#
CROSS_GCC_FIRST_VERSION		:= $(call remove_quotes,$(PTXCONF_CROSS_GCC_VERSION))
CROSS_GCC_FIRST_DL_VERSION	:= $(call remove_quotes,$(PTXCONF_CROSS_GCC_DL_VERSION))
CROSS_GCC_FIRST_MD5		:= $(call remove_quotes,$(PTXCONF_CROSS_GCC_MD5))
CROSS_GCC_FIRST			:= gcc-$(CROSS_GCC_FIRST_DL_VERSION)
CROSS_GCC_FIRST_SUFFIX		:= tar.xz
CROSS_GCC_FIRST_SOURCE		:= $(SRCDIR)/$(CROSS_GCC_FIRST).$(CROSS_GCC_FIRST_SUFFIX)
CROSS_GCC_FIRST_DIR		:= $(CROSS_BUILDDIR)/gcc-first-$(CROSS_GCC_FIRST_VERSION)
CROSS_GCC_FIRST_BUILDDIR	:= $(CROSS_GCC_FIRST_DIR)-build
CROSS_GCC_FIRST_URL		 = $(CROSS_GCC_URL)
CROSS_GCC_FIRST_BUILD_OOT	:= YES
CROSS_GCC_FIRST_DEVPKG		:= NO
CROSS_GCC_FIRST_LICENSE		:= ignore

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

CROSS_GCC_FIRST_CONF_ENV	:= \
	$(HOST_ENV) \
	CFLAGS="-g0 -O2" \
	CXXFLAGS="-g0 -O2" \
	MAKEINFO=: \
	enable_libmpx=no

#
# autoconf
#
CROSS_GCC_FIRST_CONF_TOOL	:= autoconf
CROSS_GCC_FIRST_CONF_OPT	 = \
	$(CROSS_GCC_AUTOCONF_COMMON) \
	--prefix=$(CROSS_GCC_FIRST_PREFIX) \
	\
	--disable-shared \
	--enable-languages=c \
	\
	--with-ld=$(PTXDIST_SYSROOT_CROSS)$(PTXCONF_PREFIX_CROSS)/bin/$(PTXCONF_GNU_TARGET)-ld \
	--with-as=$(PTXDIST_SYSROOT_CROSS)$(PTXCONF_PREFIX_CROSS)/bin/$(PTXCONF_GNU_TARGET)-as \
	--disable-checking \
	\
	--disable-libmudflap \
	--disable-libssp \
	--disable-libgomp \
	--disable-libquadmath \
	--disable-libatomic \
	--with-system-zlib

CROSS_GCC_FIRST_MAKE_ENV := \
	with_zstd=no

ifdef PTXDIST_ICECC
CROSS_GCC_FIRST_MAKE_ENV += \
	STAGE_CC_WRAPPER=$(PTXDIST_ICERUN)
endif

# ----------------------------------------------------------------------------
# Install
# ----------------------------------------------------------------------------

CROSS_GCC_FIRST_INSTALL_OPT := \
	install

$(STATEDIR)/cross-gcc-first.install:
	@$(call targetinfo)
	@$(call world/install, CROSS_GCC_FIRST)
	ln -sfv libgcc.a `$(CROSS_GCC_FIRST_PREFIX)/bin/$(PTXCONF_GNU_TARGET)-gcc \
		-print-libgcc-file-name | \
		sed 's/libgcc/&_eh/'`
	ln -sfv libgcc.a `$(CROSS_GCC_FIRST_PREFIX)/bin/$(PTXCONF_GNU_TARGET)-gcc \
		-print-libgcc-file-name | \
		sed 's/libgcc/&_s/'`
	@ptxd_make_setup_target_compiler $(CROSS_GCC_FIRST_PREFIX)/bin
	@$(call touch)

# vim: syntax=make
