# -*-makefile-*-
#
# Copyright (C) 2020 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
CROSS_PACKAGES-$(PTXCONF_CROSS_LLD) += cross-lld

#
# Paths and names
#
CROSS_LLD_VERSION	:= $(call remove_quotes,$(PTXCONF_CROSS_LLD_VERSION))
CROSS_LLD_MD5		:= $(call remove_quotes,$(PTXCONF_CROSS_LLD_MD5))
CROSS_LLD		:= lld-$(CROSS_LLD_VERSION)
CROSS_LLD_SUFFIX	:= src.tar.xz
CROSS_LLD_URL		:= https://github.com/llvm/llvm-project/releases/download/llvmorg-$(CROSS_LLD_VERSION)/$(CROSS_LLD).$(CROSS_LLD_SUFFIX)
CROSS_LLD_SOURCE	:= $(SRCDIR)/$(CROSS_LLD).$(CROSS_LLD_SUFFIX)
CROSS_LLD_DIR		:= $(CROSS_BUILDDIR)/$(CROSS_LLD)
CROSS_LLD_SUBDIR	:= $(CROSS_LLD).src
CROSS_LLD_STRIP_LEVEL	:= 0
CROSS_LLD_LICENSE	:= $(call remove_quotes,$(PTXCONF_CROSS_LLD_LICENSE))
CROSS_LLD_LICENSE_FILES	:= $(call remove_quotes,$(PTXCONF_CROSS_LLD_LICENSE_FILES))

CROSS_LLD_CMAKE_MODULES_VERSION	 = $(CROSS_LLVM_CMAKE_MODULES_VERSION)
CROSS_LLD_CMAKE_MODULES_MD5	 = $(CROSS_LLVM_CMAKE_MODULES_MD5)
CROSS_LLD_CMAKE_MODULES		 = $(CROSS_LLVM_CMAKE_MODULES)
CROSS_LLD_CMAKE_MODULES_SUFFIX	 = $(CROSS_LLVM_CMAKE_MODULES_SUFFIX)
CROSS_LLD_CMAKE_MODULES_URL	 = $(CROSS_LLVM_CMAKE_MODULES_URL)
CROSS_LLD_CMAKE_MODULES_SOURCE	 = $(CROSS_LLVM_CMAKE_MODULES_SOURCE)
CROSS_LLD_CMAKE_MODULES_DIR	:= $(CROSS_BUILDDIR)/$(CROSS_LLD)/cmake
CROSS_LLD_PARTS			+= CROSS_LLD_CMAKE_MODULES

CROSS_LLD_LIBUNWIND_VERSION	:= $(CROSS_LLD_VERSION)
CROSS_LLD_LIBUNWIND_MD5		:= $(call remove_quotes,$(PTXCONF_CROSS_LLVM_LIBUNWIND_MD5))
CROSS_LLD_LIBUNWIND		:= libunwind-$(CROSS_LLD_LIBUNWIND_VERSION)
CROSS_LLD_LIBUNWIND_SUFFIX	:= src.tar.xz
CROSS_LLD_LIBUNWIND_URL		:= https://github.com/llvm/llvm-project/releases/download/llvmorg-$(CROSS_LLD_LIBUNWIND_VERSION)/$(CROSS_LLD_LIBUNWIND).$(CROSS_LLD_LIBUNWIND_SUFFIX)
CROSS_LLD_LIBUNWIND_SOURCE	:= $(SRCDIR)/$(CROSS_LLD_LIBUNWIND).$(CROSS_LLD_SUFFIX)
CROSS_LLD_LIBUNWIND_DIR		:= $(CROSS_BUILDDIR)/$(CROSS_LLD)/libunwind
CROSS_LLD_PARTS			+= CROSS_LLD_LIBUNWIND

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

#
# cmake
#
CROSS_LLD_CONF_TOOL	:= cmake
CROSS_LLD_CONF_OPT	:=  \
	$(HOST_CROSS_CMAKE_OPT) \
	-G Ninja \
	-DCMAKE_INSTALL_PREFIX=$(PTXCONF_PREFIX_CROSS) \
	-DCMAKE_SKIP_INSTALL_RPATH=ON \
	-DCMAKE_SKIP_RPATH=ON \
	-DLLD_USE_VTUNE=OFF \
	-DLLD_BUILD_TOOLS=ON \
	-DLLVM_CONFIG_PATH=$(CROSS_LLVM_DIR)-build/bin/llvm-config


CROSS_LLD_LDFLAGS	:= \
	-Wl,-rpath,$$ORIGIN/../lib

$(STATEDIR)/cross-lld.prepare:
	@$(call targetinfo)
#	# needed to find compact_unwind_encoding.h
	@mkdir -vp "$(CROSS_LLD_DIR)/llvm"
	@$(call world/prepare, CROSS_LLD)
	@$(call touch)

# ----------------------------------------------------------------------------
# Install
# ----------------------------------------------------------------------------

$(STATEDIR)/cross-lld.install:
	@$(call targetinfo)
	@$(call world/install, CROSS_LLD)
	@install -vd -m755 \
		$(CROSS_LLD_PKGDIR)$(PTXCONF_PREFIX_CROSS)/$(PTXCONF_GNU_TARGET)/bin
	@ln -sfv  \
		../../bin/lld \
		$(CROSS_LLD_PKGDIR)$(PTXCONF_PREFIX_CROSS)/$(PTXCONF_GNU_TARGET)/bin/ld.lld
	@$(call touch)

# vim: syntax=make
