# -*-makefile-*-
#
# Copyright (C) 2025 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
HOST_PACKAGES-$(PTXCONF_HOST_SYSTEM_LIBXXHASH) += host-system-libxxhash
HOST_SYSTEM_LIBXXHASH_LICENSE	:= ignore

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

$(STATEDIR)/host-system-libxxhash.prepare:
	@$(call targetinfo)
	@echo "Checking for libxxhash ..."
	@pkg-config libxxhash || \
		ptxd_bailout "libxxhash development files not found!" \
		"Please install libxxhash-dev (debian) or xxhash-devel (fedora)"
	@$(call touch)

$(STATEDIR)/host-system-libxxhash.install:
	@$(call targetinfo)
	@echo libxxhash > $(STATEDIR)/host-system-xxhash.pkgconfig
	@$(call touch)

# vim: ft=make
