# -*-makefile-*-
#
# Copyright (C) 2025 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_MUSL) += musl

#
# Paths and names
#
MUSL_VERSION		:=$(call remove_quotes,$(PTXCONF_MUSL_VERSION))
MUSL_MD5		:=$(call remove_quotes,$(PTXCONF_MUSL_MD5))
MUSL			:= musl-$(MUSL_VERSION)
MUSL_SUFFIX		:= tar.gz
MUSL_URL		:= https://musl.libc.org/releases/$(MUSL).$(MUSL_SUFFIX)
MUSL_SOURCE		:= $(SRCDIR)/$(MUSL).$(MUSL_SUFFIX)
MUSL_DIR		:= $(BUILDDIR)/$(MUSL)
MUSL_LICENSE		:= $(call remove_quotes,$(PTXCONF_MUSL_LICENSE))
MUSL_LICENSE_FILES	:= $(call remove_quotes,$(PTXCONF_MUSL_LICENSE_FILES))

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

#
# not really autoconf
#
MUSL_CONF_TOOL	:= autoconf
MUSL_CONF_OPT	:=  \
	--prefix=/usr/lib/musl \
	--host=$(PTXCONF_GNU_TARGET) \
	--target=$(PTXCONF_GNU_TARGET) \
	--enable-wrapper=gcc \
	--disable-shared \
	--enable-static

# ----------------------------------------------------------------------------
# Install
# ----------------------------------------------------------------------------

MUSL_GCC_WRAPPER := \
	$(PTXDIST_SYSROOT_CROSS)$(PTXCONF_PREFIX_CROSS)/bin/$(COMPILER_PREFIX_MUSL)gcc

$(STATEDIR)/musl.install:
	@$(call targetinfo)
	@$(call world/install, MUSL)
	@echo -e '#!/bin/sh\nd="$$(dirname $$0)"\nexec "$${REALGCC:-$${d}/$(COMPILER_PREFIX)gcc}" "$$@" -specs "$$(dirname "$$(realpath "$${d}")")/sysroot-$(PTXCONF_GNU_TARGET)/usr/lib/musl/lib/musl-gcc.specs"' > $(MUSL_GCC_WRAPPER)
	@chmod +x $(MUSL_GCC_WRAPPER)
	@$(call touch)

# vim: ft=make
