# -*-makefile-*-
#
# Copyright (C) 2010 by Erwin Rol <erwin@erwinrol.com>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_SPEEX) += speex

#
# Paths and names
#
SPEEX_VERSION	:= 1.2.1
SPEEX_MD5	:= fe7bf610883ff202092b92c72fe0fe3e
SPEEX		:= speex-$(SPEEX_VERSION)
SPEEX_SUFFIX	:= tar.gz
SPEEX_URL	:= http://downloads.xiph.org/releases/speex/$(SPEEX).$(SPEEX_SUFFIX)
SPEEX_SOURCE	:= $(SRCDIR)/$(SPEEX).$(SPEEX_SUFFIX)
SPEEX_DIR	:= $(BUILDDIR)/$(SPEEX)
SPEEX_LICENSE	:= BSD-3-Clause

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

SPEEX_FFT-$(PTXCONF_SPEEX_FFT_KISS)			+= kiss
SPEEX_FFT-$(PTXCONF_SPEEX_FFT_SMALLFT)			+= smallft

#
# autoconf
#
SPEEX_CONF_TOOL := autoconf
SPEEX_CONF_OPT := \
	$(CROSS_AUTOCONF_USR) \
	--disable-valgrind \
	--$(call ptx/endis, PTXCONF_ARCH_X86)-sse \
	--$(call ptx/endis, PTXCONF_SPEEX_FIXED_POINT)-fixed-point \
	--$(call ptx/endis, PTXCONF_SPEEX_FLOAT_API)-float-api \
	--$(call ptx/endis, PTXCONF_SPEEX_BINARIES)-binaries \
	--$(call ptx/endis, PTXCONF_SPEEX_VBR)-vbr \
	--disable-arm4-asm \
	--disable-arm5e-asm \
	--$(call ptx/endis, PTXCONF_ARCH_BLACKFIN)-blackfin-asm \
	--disable-fixed-point-debug \
	--disable-ti-c55x \
	--$(call ptx/endis, PTXCONF_SPEEX_VORBIS_PSY)-vorbis-psy \
	--with-fft=$(SPEEX_FFT-y)

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/speex.targetinstall:
	@$(call targetinfo)

	@$(call install_init, speex)
	@$(call install_fixup, speex,PRIORITY,optional)
	@$(call install_fixup, speex,SECTION,base)
	@$(call install_fixup, speex,AUTHOR,"Erwin Rol <erwin@erwinrol.com>")
	@$(call install_fixup, speex,DESCRIPTION,missing)

ifdef PTXCONF_SPEEX_INSTALL_SPEEXENC
	@$(call install_copy, speex, 0, 0, 0755, -, /usr/bin/speexenc)
endif
ifdef PTXCONF_SPEEX_INSTALL_SPEEXDEC
	@$(call install_copy, speex, 0, 0, 0755, -, /usr/bin/speexdec)
endif

	@$(call install_lib, speex, 0, 0, 0644, libspeex)

	@$(call install_finish, speex)

	@$(call touch)

# vim: syntax=make
