# -*-makefile-*-
#
# Copyright (C) 2013 by Bernhard Walle <bernhard@bwalle.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_WAVEMON) += wavemon

#
# Paths and names
#
WAVEMON_VERSION		:= 0.7.5
WAVEMON_MD5		:= 77d4a0f099ca98cf98a915adc70694ba
WAVEMON			:= wavemon-$(WAVEMON_VERSION)
WAVEMON_SUFFIX		:= tar.bz2
WAVEMON_URL		:= https://github.com/uoaerg/wavemon/releases/download/v$(WAVEMON_VERSION)/$(WAVEMON).$(WAVEMON_SUFFIX)
WAVEMON_SOURCE		:= $(SRCDIR)/$(WAVEMON).$(WAVEMON_SUFFIX)
WAVEMON_DIR		:= $(BUILDDIR)/$(WAVEMON)
WAVEMON_LICENSE		:= GPL-3.0-or-later
WAVEMON_LICENSE_FILES	:= \
	file://COPYING;md5=d32239bcb673463ab874e80d47fae504

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

WAVEMON_CONF_ENV := \
	$(CROSS_ENV) \
	ac_cv_lib_cap_cap_get_flag=no

#
# autoconf
#
WAVEMON_CONF_TOOL := autoconf

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/wavemon.targetinstall:
	@$(call targetinfo)

	@$(call install_init, wavemon)
	@$(call install_fixup, wavemon,PRIORITY,optional)
	@$(call install_fixup, wavemon,SECTION,base)
	@$(call install_fixup, wavemon,AUTHOR,"Bernhard Walle <bernhard@bwalle.de>")
	@$(call install_fixup, wavemon,DESCRIPTION,missing)

	@$(call install_copy, wavemon, 0, 0, 0755, -, /usr/bin/wavemon)

	@$(call install_finish, wavemon)

	@$(call touch)

# vim: syntax=make
