
#!/bin/bash
#
# Copyright (C) 2018 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# WARNING: This file is generated with 'update_spdx.py' from
# 'licenses.json' and 'exceptions.json'.
#
# The source files can be found in the SPDX data repository:
# https://github.com/spdx/license-list-data.git

ptxd_make_spdx() {
    license="${1}"

    case "${license}" in
	0BSD) osi="true" ;;
	3D-Slicer-1.0) ;;
	AAL) osi="true" ;;
	Abstyles) ;;
	AdaCore-doc) ;;
	Adobe-2006) ;;
	Adobe-Display-PostScript) ;;
	Adobe-Glyph) ;;
	Adobe-Utopia) ;;
	ADSL) ;;
	AFL-1.1) osi="true" ;;
	AFL-1.2) osi="true" ;;
	AFL-2.0) osi="true" ;;
	AFL-2.1) osi="true" ;;
	AFL-3.0) osi="true" ;;
	Afmparse) ;;
	AGPL-1.0) deprecated="true" ;;
	AGPL-1.0-only) ;;
	AGPL-1.0-or-later) ;;
	AGPL-3.0) deprecated="true" ;;
	AGPL-3.0-only) osi="true" ;;
	AGPL-3.0-or-later) osi="true" ;;
	Aladdin) ;;
	AMD-newlib) ;;
	AMDPLPA) ;;
	AML) ;;
	AML-glslang) ;;
	AMPAS) ;;
	ANTLR-PD) ;;
	ANTLR-PD-fallback) ;;
	any-OSI) ;;
	any-OSI-perl-modules) ;;
	Apache-1.0) ;;
	Apache-1.1) osi="true" ;;
	Apache-2.0) osi="true" ;;
	APAFML) ;;
	APL-1.0) osi="true" ;;
	App-s2p) ;;
	APSL-1.0) osi="true" ;;
	APSL-1.1) osi="true" ;;
	APSL-1.2) osi="true" ;;
	APSL-2.0) osi="true" ;;
	Arphic-1999) ;;
	Artistic-1.0) osi="true" ;;
	Artistic-1.0-cl8) osi="true" ;;
	Artistic-1.0-Perl) osi="true" ;;
	Artistic-2.0) osi="true" ;;
	ASWF-Digital-Assets-1.0) ;;
	ASWF-Digital-Assets-1.1) ;;
	Baekmuk) ;;
	Bahyph) ;;
	Barr) ;;
	bcrypt-Solar-Designer) ;;
	Beerware) ;;
	Bitstream-Charter) ;;
	Bitstream-Vera) ;;
	BitTorrent-1.0) ;;
	BitTorrent-1.1) ;;
	blessing) ;;
	BlueOak-1.0.0) osi="true" ;;
	Boehm-GC) ;;
	Boehm-GC-without-fee) ;;
	Borceux) ;;
	Brian-Gladman-2-Clause) ;;
	Brian-Gladman-3-Clause) ;;
	BSD-1-Clause) osi="true" ;;
	BSD-2-Clause) osi="true" ;;
	BSD-2-Clause-Darwin) ;;
	BSD-2-Clause-first-lines) ;;
	BSD-2-Clause-FreeBSD) deprecated="true" ;;
	BSD-2-Clause-NetBSD) deprecated="true" ;;
	BSD-2-Clause-Patent) osi="true" ;;
	BSD-2-Clause-Views) ;;
	BSD-3-Clause) osi="true" ;;
	BSD-3-Clause-acpica) ;;
	BSD-3-Clause-Attribution) ;;
	BSD-3-Clause-Clear) ;;
	BSD-3-Clause-flex) ;;
	BSD-3-Clause-HP) ;;
	BSD-3-Clause-LBNL) osi="true" ;;
	BSD-3-Clause-Modification) ;;
	BSD-3-Clause-No-Military-License) ;;
	BSD-3-Clause-No-Nuclear-License) ;;
	BSD-3-Clause-No-Nuclear-License-2014) ;;
	BSD-3-Clause-No-Nuclear-Warranty) ;;
	BSD-3-Clause-Open-MPI) ;;
	BSD-3-Clause-Sun) ;;
	BSD-4-Clause) ;;
	BSD-4-Clause-Shortened) ;;
	BSD-4-Clause-UC) ;;
	BSD-4.3RENO) ;;
	BSD-4.3TAHOE) ;;
	BSD-Advertising-Acknowledgement) ;;
	BSD-Attribution-HPND-disclaimer) ;;
	BSD-Inferno-Nettverk) ;;
	BSD-Protection) ;;
	BSD-Source-beginning-file) ;;
	BSD-Source-Code) ;;
	BSD-Systemics) ;;
	BSD-Systemics-W3Works) ;;
	BSL-1.0) osi="true" ;;
	BUSL-1.1) ;;
	bzip2-1.0.5) deprecated="true" ;;
	bzip2-1.0.6) ;;
	C-UDA-1.0) ;;
	CAL-1.0) osi="true" ;;
	CAL-1.0-Combined-Work-Exception) osi="true" ;;
	Caldera) ;;
	Caldera-no-preamble) ;;
	Catharon) ;;
	CATOSL-1.1) osi="true" ;;
	CC-BY-1.0) ;;
	CC-BY-2.0) ;;
	CC-BY-2.5) ;;
	CC-BY-2.5-AU) ;;
	CC-BY-3.0) ;;
	CC-BY-3.0-AT) ;;
	CC-BY-3.0-AU) ;;
	CC-BY-3.0-DE) ;;
	CC-BY-3.0-IGO) ;;
	CC-BY-3.0-NL) ;;
	CC-BY-3.0-US) ;;
	CC-BY-4.0) ;;
	CC-BY-NC-1.0) ;;
	CC-BY-NC-2.0) ;;
	CC-BY-NC-2.5) ;;
	CC-BY-NC-3.0) ;;
	CC-BY-NC-3.0-DE) ;;
	CC-BY-NC-4.0) ;;
	CC-BY-NC-ND-1.0) ;;
	CC-BY-NC-ND-2.0) ;;
	CC-BY-NC-ND-2.5) ;;
	CC-BY-NC-ND-3.0) ;;
	CC-BY-NC-ND-3.0-DE) ;;
	CC-BY-NC-ND-3.0-IGO) ;;
	CC-BY-NC-ND-4.0) ;;
	CC-BY-NC-SA-1.0) ;;
	CC-BY-NC-SA-2.0) ;;
	CC-BY-NC-SA-2.0-DE) ;;
	CC-BY-NC-SA-2.0-FR) ;;
	CC-BY-NC-SA-2.0-UK) ;;
	CC-BY-NC-SA-2.5) ;;
	CC-BY-NC-SA-3.0) ;;
	CC-BY-NC-SA-3.0-DE) ;;
	CC-BY-NC-SA-3.0-IGO) ;;
	CC-BY-NC-SA-4.0) ;;
	CC-BY-ND-1.0) ;;
	CC-BY-ND-2.0) ;;
	CC-BY-ND-2.5) ;;
	CC-BY-ND-3.0) ;;
	CC-BY-ND-3.0-DE) ;;
	CC-BY-ND-4.0) ;;
	CC-BY-SA-1.0) ;;
	CC-BY-SA-2.0) ;;
	CC-BY-SA-2.0-UK) ;;
	CC-BY-SA-2.1-JP) ;;
	CC-BY-SA-2.5) ;;
	CC-BY-SA-3.0) ;;
	CC-BY-SA-3.0-AT) ;;
	CC-BY-SA-3.0-DE) ;;
	CC-BY-SA-3.0-IGO) ;;
	CC-BY-SA-4.0) ;;
	CC-PDDC) ;;
	CC-PDM-1.0) ;;
	CC-SA-1.0) ;;
	CC0-1.0) ;;
	CDDL-1.0) osi="true" ;;
	CDDL-1.1) ;;
	CDL-1.0) ;;
	CDLA-Permissive-1.0) ;;
	CDLA-Permissive-2.0) ;;
	CDLA-Sharing-1.0) ;;
	CECILL-1.0) ;;
	CECILL-1.1) ;;
	CECILL-2.0) ;;
	CECILL-2.1) osi="true" ;;
	CECILL-B) ;;
	CECILL-C) ;;
	CERN-OHL-1.1) ;;
	CERN-OHL-1.2) ;;
	CERN-OHL-P-2.0) osi="true" ;;
	CERN-OHL-S-2.0) osi="true" ;;
	CERN-OHL-W-2.0) osi="true" ;;
	CFITSIO) ;;
	check-cvs) ;;
	checkmk) ;;
	ClArtistic) ;;
	Clips) ;;
	CMU-Mach) ;;
	CMU-Mach-nodoc) ;;
	CNRI-Jython) ;;
	CNRI-Python) osi="true" ;;
	CNRI-Python-GPL-Compatible) ;;
	COIL-1.0) ;;
	Community-Spec-1.0) ;;
	Condor-1.1) ;;
	copyleft-next-0.3.0) ;;
	copyleft-next-0.3.1) ;;
	Cornell-Lossless-JPEG) ;;
	CPAL-1.0) osi="true" ;;
	CPL-1.0) osi="true" ;;
	CPOL-1.02) ;;
	Cronyx) ;;
	Crossword) ;;
	CrystalStacker) ;;
	CUA-OPL-1.0) osi="true" ;;
	Cube) ;;
	curl) ;;
	cve-tou) ;;
	D-FSL-1.0) ;;
	DEC-3-Clause) ;;
	diffmark) ;;
	DL-DE-BY-2.0) ;;
	DL-DE-ZERO-2.0) ;;
	DOC) ;;
	DocBook-Schema) ;;
	DocBook-Stylesheet) ;;
	DocBook-XML) ;;
	Dotseqn) ;;
	DRL-1.0) ;;
	DRL-1.1) ;;
	DSDP) ;;
	dtoa) ;;
	dvipdfm) ;;
	ECL-1.0) osi="true" ;;
	ECL-2.0) osi="true" ;;
	eCos-2.0) deprecated="true" ;;
	EFL-1.0) osi="true" ;;
	EFL-2.0) osi="true" ;;
	eGenix) ;;
	Elastic-2.0) ;;
	Entessa) osi="true" ;;
	EPICS) ;;
	EPL-1.0) osi="true" ;;
	EPL-2.0) osi="true" ;;
	ErlPL-1.1) ;;
	etalab-2.0) ;;
	EUDatagrid) osi="true" ;;
	EUPL-1.0) ;;
	EUPL-1.1) osi="true" ;;
	EUPL-1.2) osi="true" ;;
	Eurosym) ;;
	Fair) osi="true" ;;
	FBM) ;;
	FDK-AAC) ;;
	Ferguson-Twofish) ;;
	Frameworx-1.0) osi="true" ;;
	FreeBSD-DOC) ;;
	FreeImage) ;;
	FSFAP) ;;
	FSFAP-no-warranty-disclaimer) ;;
	FSFUL) ;;
	FSFULLR) ;;
	FSFULLRWD) ;;
	FTL) ;;
	Furuseth) ;;
	fwlw) ;;
	GCR-docs) ;;
	GD) ;;
	generic-xts) ;;
	GFDL-1.1) deprecated="true" ;;
	GFDL-1.1-invariants-only) ;;
	GFDL-1.1-invariants-or-later) ;;
	GFDL-1.1-no-invariants-only) ;;
	GFDL-1.1-no-invariants-or-later) ;;
	GFDL-1.1-only) ;;
	GFDL-1.1-or-later) ;;
	GFDL-1.2) deprecated="true" ;;
	GFDL-1.2-invariants-only) ;;
	GFDL-1.2-invariants-or-later) ;;
	GFDL-1.2-no-invariants-only) ;;
	GFDL-1.2-no-invariants-or-later) ;;
	GFDL-1.2-only) ;;
	GFDL-1.2-or-later) ;;
	GFDL-1.3) deprecated="true" ;;
	GFDL-1.3-invariants-only) ;;
	GFDL-1.3-invariants-or-later) ;;
	GFDL-1.3-no-invariants-only) ;;
	GFDL-1.3-no-invariants-or-later) ;;
	GFDL-1.3-only) ;;
	GFDL-1.3-or-later) ;;
	Giftware) ;;
	GL2PS) ;;
	Glide) ;;
	Glulxe) ;;
	GLWTPL) ;;
	gnuplot) ;;
	GPL-1.0) deprecated="true" ;;
	GPL-1.0+) deprecated="true" ;;
	GPL-1.0-only) ;;
	GPL-1.0-or-later) ;;
	GPL-2.0) deprecated="true" ;;
	GPL-2.0+) deprecated="true" ;;
	GPL-2.0-only) osi="true" ;;
	GPL-2.0-or-later) osi="true" ;;
	GPL-2.0-with-autoconf-exception) deprecated="true" ;;
	GPL-2.0-with-bison-exception) deprecated="true" ;;
	GPL-2.0-with-classpath-exception) deprecated="true" ;;
	GPL-2.0-with-font-exception) deprecated="true" ;;
	GPL-2.0-with-GCC-exception) deprecated="true" ;;
	GPL-3.0) deprecated="true" ;;
	GPL-3.0+) deprecated="true" ;;
	GPL-3.0-only) osi="true" ;;
	GPL-3.0-or-later) osi="true" ;;
	GPL-3.0-with-autoconf-exception) deprecated="true" ;;
	GPL-3.0-with-GCC-exception) deprecated="true" ;;
	Graphics-Gems) ;;
	gSOAP-1.3b) ;;
	gtkbook) ;;
	Gutmann) ;;
	HaskellReport) ;;
	hdparm) ;;
	HIDAPI) ;;
	Hippocratic-2.1) ;;
	HP-1986) ;;
	HP-1989) ;;
	HPND) osi="true" ;;
	HPND-DEC) ;;
	HPND-doc) ;;
	HPND-doc-sell) ;;
	HPND-export-US) ;;
	HPND-export-US-acknowledgement) ;;
	HPND-export-US-modify) ;;
	HPND-export2-US) ;;
	HPND-Fenneberg-Livingston) ;;
	HPND-INRIA-IMAG) ;;
	HPND-Intel) ;;
	HPND-Kevlin-Henney) ;;
	HPND-Markus-Kuhn) ;;
	HPND-merchantability-variant) ;;
	HPND-MIT-disclaimer) ;;
	HPND-Netrek) ;;
	HPND-Pbmplus) ;;
	HPND-sell-MIT-disclaimer-xserver) ;;
	HPND-sell-regexpr) ;;
	HPND-sell-variant) ;;
	HPND-sell-variant-MIT-disclaimer) ;;
	HPND-sell-variant-MIT-disclaimer-rev) ;;
	HPND-UC) ;;
	HPND-UC-export-US) ;;
	HTMLTIDY) ;;
	IBM-pibs) ;;
	ICU) osi="true" ;;
	IEC-Code-Components-EULA) ;;
	IJG) ;;
	IJG-short) ;;
	ImageMagick) ;;
	iMatix) ;;
	Imlib2) ;;
	Info-ZIP) ;;
	Inner-Net-2.0) ;;
	InnoSetup) ;;
	Intel) osi="true" ;;
	Intel-ACPI) ;;
	Interbase-1.0) ;;
	IPA) osi="true" ;;
	IPL-1.0) osi="true" ;;
	ISC) osi="true" ;;
	ISC-Veillard) ;;
	Jam) osi="true" ;;
	JasPer-2.0) ;;
	JPL-image) ;;
	JPNIC) ;;
	JSON) ;;
	Kastrup) ;;
	Kazlib) ;;
	Knuth-CTAN) ;;
	LAL-1.2) ;;
	LAL-1.3) ;;
	Latex2e) ;;
	Latex2e-translated-notice) ;;
	Leptonica) ;;
	LGPL-2.0) deprecated="true" ;;
	LGPL-2.0+) deprecated="true" ;;
	LGPL-2.0-only) osi="true" ;;
	LGPL-2.0-or-later) osi="true" ;;
	LGPL-2.1) deprecated="true" ;;
	LGPL-2.1+) deprecated="true" ;;
	LGPL-2.1-only) osi="true" ;;
	LGPL-2.1-or-later) osi="true" ;;
	LGPL-3.0) deprecated="true" ;;
	LGPL-3.0+) deprecated="true" ;;
	LGPL-3.0-only) osi="true" ;;
	LGPL-3.0-or-later) osi="true" ;;
	LGPLLR) ;;
	Libpng) ;;
	libpng-2.0) ;;
	libselinux-1.0) ;;
	libtiff) ;;
	libutil-David-Nugent) ;;
	LiLiQ-P-1.1) osi="true" ;;
	LiLiQ-R-1.1) osi="true" ;;
	LiLiQ-Rplus-1.1) osi="true" ;;
	Linux-man-pages-1-para) ;;
	Linux-man-pages-copyleft) ;;
	Linux-man-pages-copyleft-2-para) ;;
	Linux-man-pages-copyleft-var) ;;
	Linux-OpenIB) ;;
	LOOP) ;;
	LPD-document) ;;
	LPL-1.0) osi="true" ;;
	LPL-1.02) osi="true" ;;
	LPPL-1.0) ;;
	LPPL-1.1) ;;
	LPPL-1.2) ;;
	LPPL-1.3a) ;;
	LPPL-1.3c) osi="true" ;;
	lsof) ;;
	Lucida-Bitmap-Fonts) ;;
	LZMA-SDK-9.11-to-9.20) ;;
	LZMA-SDK-9.22) ;;
	Mackerras-3-Clause) ;;
	Mackerras-3-Clause-acknowledgment) ;;
	magaz) ;;
	mailprio) ;;
	MakeIndex) ;;
	Martin-Birgmeier) ;;
	McPhee-slideshow) ;;
	metamail) ;;
	Minpack) ;;
	MIPS) ;;
	MirOS) osi="true" ;;
	MIT) osi="true" ;;
	MIT-0) osi="true" ;;
	MIT-advertising) ;;
	MIT-Click) ;;
	MIT-CMU) ;;
	MIT-enna) ;;
	MIT-feh) ;;
	MIT-Festival) ;;
	MIT-Khronos-old) ;;
	MIT-Modern-Variant) osi="true" ;;
	MIT-open-group) ;;
	MIT-testregex) ;;
	MIT-Wu) ;;
	MITNFA) ;;
	MMIXware) ;;
	Motosoto) osi="true" ;;
	MPEG-SSG) ;;
	mpi-permissive) ;;
	mpich2) ;;
	MPL-1.0) osi="true" ;;
	MPL-1.1) osi="true" ;;
	MPL-2.0) osi="true" ;;
	MPL-2.0-no-copyleft-exception) osi="true" ;;
	mplus) ;;
	MS-LPL) ;;
	MS-PL) osi="true" ;;
	MS-RL) osi="true" ;;
	MTLL) ;;
	MulanPSL-1.0) ;;
	MulanPSL-2.0) osi="true" ;;
	Multics) osi="true" ;;
	Mup) ;;
	NAIST-2003) ;;
	NASA-1.3) osi="true" ;;
	Naumen) osi="true" ;;
	NBPL-1.0) ;;
	NCBI-PD) ;;
	NCGL-UK-2.0) ;;
	NCL) ;;
	NCSA) osi="true" ;;
	Net-SNMP) deprecated="true" ;;
	NetCDF) ;;
	Newsletr) ;;
	NGPL) osi="true" ;;
	NICTA-1.0) ;;
	NIST-PD) ;;
	NIST-PD-fallback) ;;
	NIST-Software) ;;
	NLOD-1.0) ;;
	NLOD-2.0) ;;
	NLPL) ;;
	Nokia) osi="true" ;;
	NOSL) ;;
	Noweb) ;;
	NPL-1.0) ;;
	NPL-1.1) ;;
	NPOSL-3.0) osi="true" ;;
	NRL) ;;
	NTP) osi="true" ;;
	NTP-0) ;;
	Nunit) deprecated="true" ;;
	O-UDA-1.0) ;;
	OAR) ;;
	OCCT-PL) ;;
	OCLC-2.0) osi="true" ;;
	ODbL-1.0) ;;
	ODC-By-1.0) ;;
	OFFIS) ;;
	OFL-1.0) ;;
	OFL-1.0-no-RFN) ;;
	OFL-1.0-RFN) ;;
	OFL-1.1) osi="true" ;;
	OFL-1.1-no-RFN) osi="true" ;;
	OFL-1.1-RFN) osi="true" ;;
	OGC-1.0) ;;
	OGDL-Taiwan-1.0) ;;
	OGL-Canada-2.0) ;;
	OGL-UK-1.0) ;;
	OGL-UK-2.0) ;;
	OGL-UK-3.0) ;;
	OGTSL) osi="true" ;;
	OLDAP-1.1) ;;
	OLDAP-1.2) ;;
	OLDAP-1.3) ;;
	OLDAP-1.4) ;;
	OLDAP-2.0) ;;
	OLDAP-2.0.1) ;;
	OLDAP-2.1) ;;
	OLDAP-2.2) ;;
	OLDAP-2.2.1) ;;
	OLDAP-2.2.2) ;;
	OLDAP-2.3) ;;
	OLDAP-2.4) ;;
	OLDAP-2.5) ;;
	OLDAP-2.6) ;;
	OLDAP-2.7) ;;
	OLDAP-2.8) osi="true" ;;
	OLFL-1.3) osi="true" ;;
	OML) ;;
	OpenPBS-2.3) ;;
	OpenSSL) ;;
	OpenSSL-standalone) ;;
	OpenVision) ;;
	OPL-1.0) ;;
	OPL-UK-3.0) ;;
	OPUBL-1.0) ;;
	OSET-PL-2.1) osi="true" ;;
	OSL-1.0) osi="true" ;;
	OSL-1.1) ;;
	OSL-2.0) osi="true" ;;
	OSL-2.1) osi="true" ;;
	OSL-3.0) osi="true" ;;
	PADL) ;;
	Parity-6.0.0) ;;
	Parity-7.0.0) ;;
	PDDL-1.0) ;;
	PHP-3.0) osi="true" ;;
	PHP-3.01) osi="true" ;;
	Pixar) ;;
	pkgconf) ;;
	Plexus) ;;
	pnmstitch) ;;
	PolyForm-Noncommercial-1.0.0) ;;
	PolyForm-Small-Business-1.0.0) ;;
	PostgreSQL) osi="true" ;;
	PPL) ;;
	PSF-2.0) ;;
	psfrag) ;;
	psutils) ;;
	Python-2.0) osi="true" ;;
	Python-2.0.1) ;;
	python-ldap) ;;
	Qhull) ;;
	QPL-1.0) osi="true" ;;
	QPL-1.0-INRIA-2004) ;;
	radvd) ;;
	Rdisc) ;;
	RHeCos-1.1) ;;
	RPL-1.1) osi="true" ;;
	RPL-1.5) osi="true" ;;
	RPSL-1.0) osi="true" ;;
	RSA-MD) ;;
	RSCPL) osi="true" ;;
	Ruby) ;;
	Ruby-pty) ;;
	SAX-PD) ;;
	SAX-PD-2.0) ;;
	Saxpath) ;;
	SCEA) ;;
	SchemeReport) ;;
	Sendmail) ;;
	Sendmail-8.23) ;;
	Sendmail-Open-Source-1.1) ;;
	SGI-B-1.0) ;;
	SGI-B-1.1) ;;
	SGI-B-2.0) ;;
	SGI-OpenGL) ;;
	SGP4) ;;
	SHL-0.5) ;;
	SHL-0.51) ;;
	SimPL-2.0) osi="true" ;;
	SISSL) osi="true" ;;
	SISSL-1.2) ;;
	SL) ;;
	Sleepycat) osi="true" ;;
	SMAIL-GPL) ;;
	SMLNJ) ;;
	SMPPL) ;;
	SNIA) ;;
	snprintf) ;;
	softSurfer) ;;
	Soundex) ;;
	Spencer-86) ;;
	Spencer-94) ;;
	Spencer-99) ;;
	SPL-1.0) osi="true" ;;
	ssh-keyscan) ;;
	SSH-OpenSSH) ;;
	SSH-short) ;;
	SSLeay-standalone) ;;
	SSPL-1.0) ;;
	StandardML-NJ) deprecated="true" ;;
	SugarCRM-1.1.3) ;;
	Sun-PPP) ;;
	Sun-PPP-2000) ;;
	SunPro) ;;
	SWL) ;;
	swrule) ;;
	Symlinks) ;;
	TAPR-OHL-1.0) ;;
	TCL) ;;
	TCP-wrappers) ;;
	TermReadKey) ;;
	TGPPL-1.0) ;;
	ThirdEye) ;;
	threeparttable) ;;
	TMate) ;;
	TORQUE-1.1) ;;
	TOSL) ;;
	TPDL) ;;
	TPL-1.0) ;;
	TrustedQSL) ;;
	TTWL) ;;
	TTYP0) ;;
	TU-Berlin-1.0) ;;
	TU-Berlin-2.0) ;;
	Ubuntu-font-1.0) ;;
	UCAR) ;;
	UCL-1.0) osi="true" ;;
	ulem) ;;
	UMich-Merit) ;;
	Unicode-3.0) osi="true" ;;
	Unicode-DFS-2015) ;;
	Unicode-DFS-2016) osi="true" ;;
	Unicode-TOU) ;;
	UnixCrypt) ;;
	Unlicense) osi="true" ;;
	UPL-1.0) osi="true" ;;
	URT-RLE) ;;
	Vim) ;;
	VOSTROM) ;;
	VSL-1.0) osi="true" ;;
	W3C) osi="true" ;;
	W3C-19980720) ;;
	W3C-20150513) osi="true" ;;
	w3m) ;;
	Watcom-1.0) osi="true" ;;
	Widget-Workshop) ;;
	Wsuipa) ;;
	WTFPL) ;;
	wwl) ;;
	wxWindows) deprecated="true" ;;
	X11) ;;
	X11-distribute-modifications-variant) ;;
	X11-swapped) ;;
	Xdebug-1.03) ;;
	Xerox) ;;
	Xfig) ;;
	XFree86-1.1) ;;
	xinetd) ;;
	xkeyboard-config-Zinoviev) ;;
	xlock) ;;
	Xnet) osi="true" ;;
	xpp) ;;
	XSkat) ;;
	xzoom) ;;
	YPL-1.0) ;;
	YPL-1.1) ;;
	Zed) ;;
	Zeeff) ;;
	Zend-2.0) ;;
	Zimbra-1.3) ;;
	Zimbra-1.4) ;;
	Zlib) osi="true" ;;
	zlib-acknowledgement) ;;
	ZPL-1.1) ;;
	ZPL-2.0) osi="true" ;;
	ZPL-2.1) osi="true" ;;
	389-exception) exception="true" ;;
	Asterisk-exception) exception="true" ;;
	Asterisk-linking-protocols-exception) exception="true" ;;
	Autoconf-exception-2.0) exception="true" ;;
	Autoconf-exception-3.0) exception="true" ;;
	Autoconf-exception-generic) exception="true" ;;
	Autoconf-exception-generic-3.0) exception="true" ;;
	Autoconf-exception-macro) exception="true" ;;
	Bison-exception-1.24) exception="true" ;;
	Bison-exception-2.2) exception="true" ;;
	Bootloader-exception) exception="true" ;;
	CGAL-linking-exception) exception="true" ;;
	Classpath-exception-2.0) exception="true" ;;
	CLISP-exception-2.0) exception="true" ;;
	cryptsetup-OpenSSL-exception) exception="true" ;;
	DigiRule-FOSS-exception) exception="true" ;;
	eCos-exception-2.0) exception="true" ;;
	erlang-otp-linking-exception) exception="true" ;;
	Fawkes-Runtime-exception) exception="true" ;;
	FLTK-exception) exception="true" ;;
	fmt-exception) exception="true" ;;
	Font-exception-2.0) exception="true" ;;
	freertos-exception-2.0) exception="true" ;;
	GCC-exception-2.0) exception="true" ;;
	GCC-exception-2.0-note) exception="true" ;;
	GCC-exception-3.1) exception="true" ;;
	Gmsh-exception) exception="true" ;;
	GNAT-exception) exception="true" ;;
	GNOME-examples-exception) exception="true" ;;
	GNU-compiler-exception) exception="true" ;;
	gnu-javamail-exception) exception="true" ;;
	GPL-3.0-389-ds-base-exception) exception="true" ;;
	GPL-3.0-interface-exception) exception="true" ;;
	GPL-3.0-linking-exception) exception="true" ;;
	GPL-3.0-linking-source-exception) exception="true" ;;
	GPL-CC-1.0) exception="true" ;;
	GStreamer-exception-2005) exception="true" ;;
	GStreamer-exception-2008) exception="true" ;;
	harbour-exception) exception="true" ;;
	i2p-gpl-java-exception) exception="true" ;;
	Independent-modules-exception) exception="true" ;;
	KiCad-libraries-exception) exception="true" ;;
	LGPL-3.0-linking-exception) exception="true" ;;
	libpri-OpenH323-exception) exception="true" ;;
	Libtool-exception) exception="true" ;;
	Linux-syscall-note) exception="true" ;;
	LLGPL) exception="true" ;;
	LLVM-exception) exception="true" ;;
	LZMA-exception) exception="true" ;;
	mif-exception) exception="true" ;;
	mxml-exception) exception="true" ;;
	OCaml-LGPL-linking-exception) exception="true" ;;
	OCCT-exception-1.0) exception="true" ;;
	OpenJDK-assembly-exception-1.0) exception="true" ;;
	openvpn-openssl-exception) exception="true" ;;
	PCRE2-exception) exception="true" ;;
	PS-or-PDF-font-exception-20170817) exception="true" ;;
	QPL-1.0-INRIA-2004-exception) exception="true" ;;
	Qt-GPL-exception-1.0) exception="true" ;;
	Qt-LGPL-exception-1.1) exception="true" ;;
	Qwt-exception-1.0) exception="true" ;;
	romic-exception) exception="true" ;;
	RRDtool-FLOSS-exception-2.0) exception="true" ;;
	SANE-exception) exception="true" ;;
	SHL-2.0) exception="true" ;;
	SHL-2.1) exception="true" ;;
	stunnel-exception) exception="true" ;;
	SWI-exception) exception="true" ;;
	Swift-exception) exception="true" ;;
	Texinfo-exception) exception="true" ;;
	u-boot-exception-2.0) exception="true" ;;
	UBDL-exception) exception="true" ;;
	Universal-FOSS-exception-1.0) exception="true" ;;
	vsftpd-openssl-exception) exception="true" ;;
	WxWindows-exception-3.1) exception="true" ;;
	x11vnc-openssl-exception) exception="true" ;;
	*) return 1 ;;
    esac
}
export -f ptxd_make_spdx
