# -*-makefile-*-
#
# Copyright (C) 2017 by Bastian Stender <bst@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
HOST_PACKAGES-$(PTXCONF_HOST_MARIADB) += host-mariadb

# ----------------------------------------------------------------------------
# Prepare + Compile
# ----------------------------------------------------------------------------

#
# cmake
#
HOST_MARIADB_CONF_TOOL	:= cmake

# Note: several options disappear when they are set to NO/OFF
HOST_MARIADB_CONF_OPT	:= \
	$(HOST_CMAKE_OPT) \
	-DCMAKE_INSTALL_PREFIX=/usr \
	-DAWS_SDK_EXTERNAL_PROJECT=OFF \
	-DCONC_DEFAULT_SSL_VERIFY_SERVER_CERT=ON \
	-DCONC_WITH_BOOST_CONTEXT=OFF \
	-DCONC_WITH_DOCS=OFF \
	-DCONC_WITH_DYNCOL=OFF \
	-DCONC_WITH_UNIT_TESTS=OFF \
	-DDISABLE_SHARED=OFF \
	-DENABLED_JSON_WRITER_CONSISTENCY_CHECKS=OFF \
	-DENABLED_PROFILING=OFF \
	-DENABLE_GCOV=OFF \
	-DFEATURE_SUMMARY=ON \
	-DGSSAPI_FOUND=OFF \
	-DINSTALL_LAYOUT=STANDALONE \
	-DMYSQL_MAINTAINER_MODE=OFF \
	-DPLUGIN_ARCHIVE=NO \
	-DPLUGIN_AUDIT_NULL=NO \
	-DPLUGIN_AUTH_0X0100=NO \
	-DPLUGIN_AUTH_ED25519=NO \
	-DPLUGIN_AUTH_PAM=NO \
	-DPLUGIN_AUTH_PAM_V1=NO \
	-DPLUGIN_AUTH_SOCKET=NO \
	-DPLUGIN_AUTH_TEST_PLUGIN=NO \
	-DPLUGIN_BLACKHOLE=NO \
	-DPLUGIN_CONNECT=NO \
	-DPLUGIN_DAEMON_EXAMPLE=NO \
	-DPLUGIN_DEBUG_KEY_MANAGEMENT=NO \
	-DPLUGIN_DIALOG_EXAMPLES=NO \
	-DPLUGIN_DISKS=NO \
	-DPLUGIN_EXAMPLE=NO \
	-DPLUGIN_EXAMPLE_KEY_MANAGEMENT=NO \
	-DPLUGIN_FEDERATED=NO \
	-DPLUGIN_FEDERATEDX=NO \
	-DPLUGIN_FEEDBACK=STATIC \
	-DPLUGIN_FILE_KEY_MANAGEMENT=NO \
	-DPLUGIN_FTEXAMPLE=NO \
	-DPLUGIN_FUNC_TEST=NO \
	-DPLUGIN_HANDLERSOCKET=NO \
	-DPLUGIN_INNOBASE=NO \
	-DPLUGIN_LOCALES=NO \
	-DPLUGIN_METADATA_LOCK_INFO=NO \
	-DPLUGIN_MROONGA=NO \
	-DPLUGIN_PARTITION=NO \
	-DPLUGIN_PASSWORD_REUSE_CHECK=NO \
	-DPLUGIN_PERFSCHEMA=NO \
	-DPLUGIN_QA_AUTH_CLIENT=NO \
	-DPLUGIN_QA_AUTH_INTERFACE=NO \
	-DPLUGIN_QA_AUTH_SERVER=NO \
	-DPLUGIN_QUERY_CACHE_INFO=NO \
	-DPLUGIN_QUERY_RESPONSE_TIME=NO \
	-DPLUGIN_ROCKSDB=NO \
	-DPLUGIN_SEQUENCE=NO \
	-DPLUGIN_SERVER_AUDIT=NO \
	-DPLUGIN_SIMPLE_PASSWORD_CHECK=NO \
	-DPLUGIN_SPHINX=NO \
	-DPLUGIN_SQL_ERRLOG=NO \
	-DPLUGIN_TEST_SQL_DISCOVERY=NO \
	-DPLUGIN_TEST_SQL_SERVICE=NO \
	-DPLUGIN_TEST_VERSIONING=NO \
	-DPLUGIN_THREAD_POOL_INFO=NO \
	-DPLUGIN_TYPE_MYSQL_JSON=NO \
	-DPLUGIN_TYPE_MYSQL_TIMESTAMP=NO \
	-DPLUGIN_TYPE_TEST=NO \
	-DPLUGIN_USER_VARIABLES=NO \
	-DSECURITY_HARDENED=ON \
	-DUPDATE_SUBMODULES=OFF \
	-DUSE_ARIA_FOR_TMP_TABLES=ON \
	-DWITHOUT_PACKED_SORT_KEYS=OFF \
	-DWITHOUT_SERVER=OFF \
	-DWITH_ASAN=OFF \
	-DWITH_COLUMNSTORE_LZ4=OFF \
	-DWITH_DBUG_TRACE=OFF \
	-DWITH_EMBEDDED_SERVER=OFF \
	-DWITH_EXTRA_CHARSETS=none \
	-DWITH_GPROF=OFF \
	-DWITH_INNODB_AHI=OFF \
	-DWITH_INNODB_EXTRA_DEBUG=OFF \
	-DWITH_INNODB_PMEM=OFF \
	-DWITH_INNODB_ROOT_GUESS=OFF \
	-DWITH_LIBAIO=OFF \
	-DWITH_LIBFMT=OFF \
	-DWITH_LIBWRAP=OFF \
	-DWITH_MSAN=OFF \
	-DWITH_NUMA=OFF \
	-DWITH_PCRE=OFF \
	-DWITH_PROTECT_STATEMENT_MEMROOT=OFF \
	-DWITH_READLINE=OFF \
	-DWITH_SAFEMALLOC=OFF \
	-DWITH_SYSTEMD=no \
	-DWITH_TSAN=OFF \
	-DWITH_UBSAN=OFF \
	-DWITH_UNIT_TESTS=OFF \
	-DWITH_URING=OFF \
	-DWITH_VALGRIND=OFF \
	-DWITH_WSREP=OFF \
	-DWITH_WSREP_ALL=OFF \
	-DWITH_ZLIB=bundled \
	\
	-DOPENSSL_FOUND=TRUE \
	-DCMAKE_DISABLE_FIND_PACKAGE_BISON=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_BZip2=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_Boost=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_CURL=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_GSSAPI=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_Git=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_LZ4=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_LZO=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_LibLZMA=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_LibXml2=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_OpenSSL=ON \
	-DCMAKE_DISABLE_FIND_PACKAGE_Snappy=ON

HOST_MARIADB_CXXFLAGS := -std=c++98

HOST_MARIADB_MAKE_OPT := \
	comp_err \
	comp_sql \
	factorial \
	gen_lex_hash \
	gen_lex_token \
	uca-dump

# ----------------------------------------------------------------------------
# Install
# ----------------------------------------------------------------------------

$(STATEDIR)/host-mariadb.install:
	@$(call targetinfo)
	@rm -rf $(HOST_MARIADB_PKGDIR)
#	# install helper tools
	@install -vD -m 644 $(HOST_MARIADB_DIR)-build/import_executables.cmake \
		$(HOST_MARIADB_PKGDIR)/usr/share/mariadb/import_executables.cmake
	@sed -i 's;$(HOST_MARIADB_DIR)-build/.*/;@SYSROOT@/usr/bin/mariadb/;' \
		$(HOST_MARIADB_PKGDIR)/usr/share/mariadb/import_executables.cmake
	@install -vD -m 755 $(HOST_MARIADB_DIR)-build/extra/comp_err $(HOST_MARIADB_PKGDIR)/usr/bin/mariadb/comp_err
	@install -vD -m 755 $(HOST_MARIADB_DIR)-build/scripts/comp_sql $(HOST_MARIADB_PKGDIR)/usr/bin/mariadb/comp_sql
	@install -vD -m 755 $(HOST_MARIADB_DIR)-build/dbug/factorial $(HOST_MARIADB_PKGDIR)/usr/bin/mariadb/factorial
	@install -vD -m 755 $(HOST_MARIADB_DIR)-build/sql/gen_lex_hash $(HOST_MARIADB_PKGDIR)/usr/bin/mariadb/gen_lex_hash
	@install -vD -m 755 $(HOST_MARIADB_DIR)-build/sql/gen_lex_token $(HOST_MARIADB_PKGDIR)/usr/bin/mariadb/gen_lex_token
	@install -vD -m 755 $(HOST_MARIADB_DIR)-build/strings/uca-dump $(HOST_MARIADB_PKGDIR)/usr/bin/mariadb/uca-dump
	@$(call touch)

$(STATEDIR)/host-mariadb.install.post:
	@$(call targetinfo)
	@$(call world/install.post, HOST_MARIADB)
#	# correct helper tool paths
	@sed -i 's;@SYSROOT@;$(PTXDIST_SYSROOT_HOST);' \
		$(PTXDIST_SYSROOT_HOST)/usr/share/mariadb/import_executables.cmake
	@$(call touch)

# vim: syntax=make
