# -*-makefile-*-
#
# Copyright (C) 2020 by Philipp Zabel <p.zabel@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
HOST_PACKAGES-$(PTXCONF_HOST_SHADERC) += host-shaderc

HOST_SHADERC_GLSLANG_MD5		:= $(SHADERC_GLSLANG_MD5)
HOST_SHADERC_GLSLANG_URL		:= $(SHADERC_GLSLANG_URL)
HOST_SHADERC_GLSLANG_SOURCE		:= $(SHADERC_GLSLANG_SOURCE)
HOST_SHADERC_GLSLANG_DIR		:= $(HOST_SHADERC_DIR)/third_party/glslang

HOST_SHADERC_SPIRV_TOOLS_MD5		= $(SHADERC_SPIRV_TOOLS_MD5)
HOST_SHADERC_SPIRV_TOOLS_URL		= $(SHADERC_SPIRV_TOOLS_URL)
HOST_SHADERC_SPIRV_TOOLS_SOURCE		= $(SHADERC_SPIRV_TOOLS_SOURCE)
HOST_SHADERC_SPIRV_TOOLS_DIR		= $(HOST_SHADERC_DIR)/third_party/spirv-tools

HOST_SHADERC_SPIRV_HEADERS_MD5		= $(SHADERC_SPIRV_HEADERS_MD5)
HOST_SHADERC_SPIRV_HEADERS_URL		= $(SHADERC_SPIRV_HEADERS_URL)
HOST_SHADERC_SPIRV_HEADERS_SOURCE	= $(SHADERC_SPIRV_HEADERS_SOURCE)
HOST_SHADERC_SPIRV_HEADERS_DIR		= $(HOST_SHADERC_DIR)/third_party/spirv-tools/external/spirv-headers

HOST_SHADERC_PARTS			+= \
	HOST_SHADERC_GLSLANG \
	HOST_SHADERC_SPIRV_TOOLS \
	HOST_SHADERC_SPIRV_HEADERS

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

HOST_SHADERC_CONF_TOOL	:= cmake
HOST_SHADERC_CONF_OPT	:= \
	$(HOST_CMAKE_OPT) \
	-DCMAKE_BUILD_TYPE=Release \
	-DALLOW_EXTERNAL_SPIRV_TOOLS=OFF \
	-DASCIIDOCTOR_EXE=ASCIIDOCTOR_EXE-NOTFOUND \
	-DBUILD_EXTERNAL=ON \
	-DBUILD_SHARED_LIBS=OFF \
	-DBUILD_WERROR=OFF \
	-DDISABLE_EXCEPTIONS=OFF \
	-DDISABLE_RTTI=OFF \
	-DENABLE_EXCEPTIONS=OFF \
	-DENABLE_EXCEPTIONS_ON_MSVC=ON \
	-DENABLE_GLSLANG_BINARIES=ON \
	-DENABLE_GLSLANG_JS=OFF \
	-DENABLE_HLSL=ON \
	-DENABLE_OPT=ON \
	-DENABLE_PCH=ON \
	-DENABLE_RTTI=OFF \
	-DENABLE_SPIRV=ON \
	-DENABLE_SPVREMAPPER=ON \
	-DGLSLANG_TESTS=OFF \
	-DSHADERC_ENABLE_WERROR_COMPILE=ON \
	-DSHADERC_ENABLE_WGSL_OUTPUT=OFF \
	-DSHADERC_SKIP_COPYRIGHT_CHECK=OFF \
	-DSHADERC_SKIP_EXAMPLES=ON \
	-DSHADERC_SKIP_EXECUTABLES=OFF \
	-DSHADERC_SKIP_INSTALL=OFF \
	-DSHADERC_SKIP_TESTS=ON \
	-DSPIRV_ALLOW_TIMERS=ON \
	-DSPIRV_BUILD_COMPRESSION=OFF \
	-DSPIRV_BUILD_FUZZER=OFF \
	-DSPIRV_BUILD_LIBFUZZER_TARGETS=OFF \
	-DSPIRV_CHECK_CONTEXT=ON \
	-DSPIRV_COLOR_TERMINAL=ON \
	-DSPIRV_CROSS_EXCEPTIONS_TO_ASSERTIONS=OFF \
	-DSPIRV_HEADERS_ENABLE_INSTALL=OFF \
	-DSPIRV_HEADERS_ENABLE_TESTS=OFF \
	-DSPIRV_LIB_FUZZING_ENGINE_LINK_OPTIONS= \
	-DSPIRV_LOG_DEBUG=OFF \
	-DSPIRV_SKIP_EXECUTABLES=OFF \
	-DSPIRV_SKIP_TESTS=ON \
	-DSPIRV_TOOLS_BUILD_STATIC=ON \
	-DSPIRV_TOOLS_INSTALL_EMACS_HELPERS=OFF \
	-DSPIRV_WARN_EVERYTHING=OFF \
	-DSPIRV_WERROR=ON \
	\
	-DPython_EXECUTABLE=$(PTXDIST_SYSROOT_HOST)/usr/lib/wrapper/$(SYSTEMPYTHON3) \
	-DPython3_EXECUTABLE=$(PTXDIST_SYSROOT_HOST)/usr/lib/wrapper/$(SYSTEMPYTHON3)

# vim: syntax=make
