# -*-makefile-*-
#
# Copyright (C) 2024 by Philipp Zabel <p.zabel@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
HOST_PACKAGES-$(PTXCONF_HOST_SPIRV_TOOLS) += host-spirv-tools

HOST_SPIRV_TOOLS_SPIRV_HEADERS_MD5	= $(SPIRV_TOOLS_SPIRV_HEADERS_MD5)
HOST_SPIRV_TOOLS_SPIRV_HEADERS_URL	= $(SPIRV_TOOLS_SPIRV_HEADERS_URL)
HOST_SPIRV_TOOLS_SPIRV_HEADERS_SOURCE	= $(SPIRV_TOOLS_SPIRV_HEADERS_SOURCE)
HOST_SPIRV_TOOLS_SPIRV_HEADERS_DIR	= $(HOST_SPIRV_TOOLS_DIR)/external/spirv-headers

HOST_SPIRV_TOOLS_PARTS		+= HOST_SPIRV_TOOLS_SPIRV_HEADERS

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

HOST_SPIRV_TOOLS_CONF_TOOL	:= cmake
HOST_SPIRV_TOOLS_CONF_OPT	:= \
	$(HOST_CMAKE_OPT) \
	-DENABLE_RTTI=OFF \
	-DSKIP_SPIRV_TOOLS_INSTALL=OFF \
	-DSPIRV_ALLOW_TIMERS=ON \
	-DSPIRV_BUILD_COMPRESSION=OFF \
	-DSPIRV_BUILD_FUZZER=OFF \
	-DSPIRV_BUILD_LIBFUZZER_TARGETS=OFF \
	-DSPIRV_CHECK_CONTEXT=ON \
	-DSPIRV_COLOR_TERMINAL=ON \
	-DSPIRV_HEADERS_ENABLE_INSTALL=OFF \
	-DSPIRV_HEADERS_ENABLE_TESTS=OFF \
	-DSPIRV_LIB_FUZZING_ENGINE_LINK_OPTIONS= \
	-DSPIRV_LOG_DEBUG=OFF \
	-DSPIRV_SKIP_EXECUTABLES=ON \
	-DSPIRV_TOOLS_BUILD_STATIC=ON \
	-DSPIRV_TOOLS_INSTALL_EMACS_HELPERS=OFF \
	-DSPIRV_WARN_EVERYTHING=OFF \
	-DSPIRV_WERROR=OFF

# vim: syntax=make
