# -*-makefile-*-
#
# Copyright (C) 2016 by Florian Scherf <f.scherf@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_PYTHON3_IPYTHON) += python3-ipython

#
# Paths and names
#
PYTHON3_IPYTHON_VERSION		:= 9.9.0
PYTHON3_IPYTHON_MD5		:= 0028a4f0b64c27033f4f38d71edcd8db
PYTHON3_IPYTHON			:= ipython-$(PYTHON3_IPYTHON_VERSION)
PYTHON3_IPYTHON_SUFFIX		:= tar.gz
PYTHON3_IPYTHON_URL		:= $(call ptx/mirror-pypi, ipython, $(PYTHON3_IPYTHON).$(PYTHON3_IPYTHON_SUFFIX))
PYTHON3_IPYTHON_SOURCE		:= $(SRCDIR)/$(PYTHON3_IPYTHON).$(PYTHON3_IPYTHON_SUFFIX)
PYTHON3_IPYTHON_DIR		:= $(BUILDDIR)/$(PYTHON3_IPYTHON)
PYTHON3_IPYTHON_LICENSE		:= BSD-3-Clause

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

PYTHON3_IPYTHON_CONF_TOOL	:= python3

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/python3-ipython.targetinstall:
	@$(call targetinfo)

	@$(call install_init, python3-ipython)
	@$(call install_fixup, python3-ipython, PRIORITY, optional)
	@$(call install_fixup, python3-ipython, SECTION, base)
	@$(call install_fixup, python3-ipython, AUTHOR, "Florian Scherf <f.scherf@pengutronix.de>")
	@$(call install_fixup, python3-ipython, DESCRIPTION, missing)

#	# We have to install the source code to avoid python3 error: "OSError: could not get source code"
	@$(call install_glob, python3-ipython, 0, 0, -, \
		$(PYTHON3_SITEPACKAGES)/IPython,, *.pyc)

	@$(call install_copy, python3-ipython, 0, 0, 0755, -, /usr/bin/ipython3)

	@$(call install_finish, python3-ipython)

	@$(call touch)

# vim: syntax=make
