# -*-makefile-*-
#
# Copyright (C) 2019 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_SSHFS) += sshfs

#
# Paths and names
#
SSHFS_VERSION	:= 3.7.3
SSHFS_MD5	:= f704f0d1800bdb5214030a1603e8c6d6
SSHFS		:= sshfs-$(SSHFS_VERSION)
SSHFS_SUFFIX	:= tar.xz
SSHFS_URL	:= https://github.com/libfuse/sshfs/releases/download/$(SSHFS)/$(SSHFS).$(SSHFS_SUFFIX)
SSHFS_SOURCE	:= $(SRCDIR)/$(SSHFS).$(SSHFS_SUFFIX)
SSHFS_DIR	:= $(BUILDDIR)/$(SSHFS)
SSHFS_LICENSE	:= GPL-2.0-only
SSHFS_LICENSE_FILES	:= file://COPYING;md5=b234ee4d69f5fce4486a80fdaf4a4263

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

#
# meson
#
SSHFS_CONF_TOOL	:= meson

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/sshfs.targetinstall:
	@$(call targetinfo)

	@$(call install_init, sshfs)
	@$(call install_fixup, sshfs,PRIORITY,optional)
	@$(call install_fixup, sshfs,SECTION,base)
	@$(call install_fixup, sshfs,AUTHOR,"Michael Olbrich <m.olbrich@pengutronix.de>")
	@$(call install_fixup, sshfs,DESCRIPTION,missing)

	@$(call install_copy, sshfs, 0, 0, 0755, -, /usr/bin/sshfs)
	@$(call install_link, sshfs, ../bin/sshfs, /usr/sbin/mount.sshfs)
	@$(call install_link, sshfs, ../bin/sshfs, /usr/sbin/mount.fuse.sshfs)

	@$(call install_finish, sshfs)

	@$(call touch)

# vim: syntax=make
