# -*-makefile-*-
#
# Copyright (C) 2014 by Michael Olbrich <m.olbrich@pengutronix.de>
#
# For further information about the PTXdist project and license conditions
# see the README file.
#

#
# We provide this package
#
PACKAGES-$(PTXCONF_XORG_LIB_XSHMFENCE) += xorg-lib-xshmfence

#
# Paths and names
#
XORG_LIB_XSHMFENCE_VERSION	:= 1.3.3
XORG_LIB_XSHMFENCE_MD5		:= 9805be7e18f858bed9938542ed2905dc
XORG_LIB_XSHMFENCE		:= libxshmfence-$(XORG_LIB_XSHMFENCE_VERSION)
XORG_LIB_XSHMFENCE_SUFFIX	:= tar.xz
XORG_LIB_XSHMFENCE_URL		:= $(call ptx/mirror, XORG, individual/lib/$(XORG_LIB_XSHMFENCE).$(XORG_LIB_XSHMFENCE_SUFFIX))
XORG_LIB_XSHMFENCE_SOURCE	:= $(SRCDIR)/$(XORG_LIB_XSHMFENCE).$(XORG_LIB_XSHMFENCE_SUFFIX)
XORG_LIB_XSHMFENCE_DIR		:= $(BUILDDIR)/$(XORG_LIB_XSHMFENCE)
XORG_LIB_XSHMFENCE_LICENSE	:= HPND-sell-variant
XORG_LIB_XSHMFENCE_LICENSE_FILES := \
	file://COPYING;md5=47e508ca280fde97906eacb77892c3ac

# ----------------------------------------------------------------------------
# Prepare
# ----------------------------------------------------------------------------

#
# autoconf
#
XORG_LIB_XSHMFENCE_CONF_TOOL	:= autoconf
XORG_LIB_XSHMFENCE_CONF_OPT	:= \
	$(CROSS_AUTOCONF_USR) \
	--disable-selective-werror \
	--disable-strict-compilation \
	$(GLOBAL_LARGE_FILE_OPTION) \
	--enable-futex \
	--$(call ptx/endis, PTXDIST_Y2038)-year2038

# ----------------------------------------------------------------------------
# Target-Install
# ----------------------------------------------------------------------------

$(STATEDIR)/xorg-lib-xshmfence.targetinstall:
	@$(call targetinfo)

	@$(call install_init, xorg-lib-xshmfence)
	@$(call install_fixup, xorg-lib-xshmfence,PRIORITY,optional)
	@$(call install_fixup, xorg-lib-xshmfence,SECTION,base)
	@$(call install_fixup, xorg-lib-xshmfence,AUTHOR,"Michael Olbrich <m.olbrich@pengutronix.de>")
	@$(call install_fixup, xorg-lib-xshmfence,DESCRIPTION,missing)

	@$(call install_lib, xorg-lib-xshmfence, 0, 0, 0644, libxshmfence)

	@$(call install_finish, xorg-lib-xshmfence)

	@$(call touch)

# vim: syntax=make
